let username = document.getElementById('name')
let email = document.getElementById('email')
let password = document.getElementById('password')
let confirmPassword = document.getElementById('confirm-password')
let form = document.querySelector('form')

// check all input 
function validateInputs(inputs) {
    inputs.forEach(input => {
        if (input.value === '') {
            input.classList.add('error')
        } else {
            input.classList.remove('error')
            input.classList.add('success')
        }
    });
}

// check email function 
const emailValidate = (email) => {
    const reg = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;

    if (reg.test(email.value)) {
        // email.classList.remove('error')
        email.classList.add('success')
    } else {
        email.classList.add('error')
    }
}

// password checking 
const checkPassword = (password) => {
    if (password.value.length < 8) {
        password.classList.add('error');
    } else {
        password.classList.remove('error');
        password.classList.add('success');
    }
}

// Checking the confirm password 
const checkConfirmPassword = (password, confirmPassword) => { 
    if (password.value !== confirmPassword.value) {
        confirmPassword.classList.add('error')
    }
}


form.addEventListener('submit', (event) => {
    event.preventDefault();
    validateInputs([username, email, password, confirmPassword])
    emailValidate(email)
    checkPassword(password)
    checkConfirmPassword(password, confirmPassword)
})
